IF EXISTS (SELECT
						 *
					 FROM
						 SYS.VIEWS
					 WHERE
						OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_PED_VD_FASES_FATURAMENTO]'))
	DROP VIEW [DBO].[V_EST_PED_VD_FASES_FATURAMENTO]
GO
--SELECT * FROM V_EST_PED_VD_FASES_FATURAMENTO WHERE DT_EMI_NF='2018-08-08' AND CD_FILIAL = 903 AND CD_EMP=1
CREATE VIEW [dbo].[V_EST_PED_VD_FASES_FATURAMENTO]AS
SELECT
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_CLI,
	EST_NF_SAI.DT_EMI_NF,
	ISNULL(EST_PED_VD.CD_PED,0) AS PRE_FATURA,
	CONVERT(CHAR(16),EST_PED_VD.DT_GRAVACAO,120) AS HORA_PREFATURA,
	CONVERT(CHAR(16),EST_PED_VD_CONF.DT_CAD,120) AS HORA_CHECKOUT,
	DATEDIFF(HOUR,CONVERT(CHAR(16),EST_PED_VD.DT_TRANSACAO,120),CONVERT(CHAR(16),EST_PED_VD_CONF.DT_CAD,120)) AS DIF_RES_CHECKOUT_HORAS,
	EST_NF_SAI.NF_NF AS NUMERO_NOTA,
	CONVERT(CHAR(10),EST_NF_SAI.DT_EMI_NF,120) + ' ' +
	CONVERT(CHAR(5),EST_NF_SAI.HR_EMI_NF,114) AS HORA_NOTA_FISCAL_SAIDA,
	DATEDIFF(MINUTE,CONVERT(CHAR(16),EST_PED_VD.DT_GRAVACAO,120),
	CONVERT(CHAR(10),EST_NF_SAI.DT_EMI_NF,120) + ' ' +
	CONVERT(CHAR(5),EST_NF_SAI.HR_EMI_NF,114)) AS DIF_PRE_NOTA_FISCAL_MINUTOS,
	CONVERT(CHAR(16),DT_RECBTO,120) AS DATA_VALIDACAO_SEFAZ,
	DATEDIFF(MINUTE,CONVERT(CHAR(10),EST_NF_SAI.DT_EMI_NF,120) + ' ' +
	CONVERT(CHAR(5),EST_NF_SAI.HR_EMI_NF,114),CONVERT(CHAR(16),DT_RECBTO,120)) AS DIF_NOTA_FISCAL_VALIDACAO_SEFAZ_MINUTOS,
	CONVERT(CHAR(16),EST_NF_SAI_CHECKIN_ENTRADA.DT_CAD,120) AS HORA_DATA_CHECKIN_DESTINO,
	CONVERT(CHAR(10),EST_NF_ENT.DT_ENT,120) + ' ' +
	CONVERT(CHAR(5),EST_NF_ENT.HR_ENT,114) AS HORA_NOTA_FISCAL_ENTRADA_DESTINO
FROM
	EST_NF_SAI LEFT OUTER JOIN EST_NF_SAI_PED_VD ON
	EST_NF_SAI.CD_EMP = EST_NF_SAI_PED_VD.CD_EMP AND
	EST_NF_SAI.CD_FILIAL = EST_NF_SAI_PED_VD.CD_FILIAL AND
	EST_NF_SAI.CD_NF = EST_NF_SAI_PED_VD.CD_NF 
	LEFT OUTER JOIN EST_PED_VD ON
	EST_NF_SAI_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
	EST_NF_SAI_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
	EST_NF_SAI_PED_VD.CD_PED = EST_PED_VD.CD_PED 
	LEFT OUTER JOIN EST_PED_VD_CONF ON
	EST_PED_VD.CD_EMP = EST_PED_VD_CONF.CD_EMP AND
	EST_PED_VD.CD_FILIAL = EST_PED_VD_CONF.CD_FILIAL AND
	EST_PED_VD.CD_PED = EST_PED_VD_CONF.CD_PED 
	LEFT OUTER JOIN EST_NF_SAI_NFE ON
	EST_NF_SAI_PED_VD.CD_EMP = EST_NF_SAI_NFE.CD_EMP AND
	EST_NF_SAI_PED_VD.CD_FILIAL = EST_NF_SAI_NFE.CD_FILIAL AND
	EST_NF_SAI_PED_VD.CD_NF = EST_NF_SAI_NFE.CD_NF 
	LEFT OUTER JOIN EST_NF_SAI_CHECKIN_ENTRADA ON
	EST_NF_SAI.CD_EMP = EST_NF_SAI_CHECKIN_ENTRADA.CD_EMP AND
	EST_NF_SAI.CD_FILIAL = EST_NF_SAI_CHECKIN_ENTRADA.CD_FILIAL AND
	EST_NF_SAI.CD_NF = EST_NF_SAI_CHECKIN_ENTRADA.CD_NF 
	LEFT OUTER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON
	EST_NF_SAI.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP AND
	EST_NF_SAI.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG AND
	EST_NF_SAI.CD_NF=EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_SAI
	LEFT OUTER JOIN EST_NF_ENT ON
	EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP = EST_NF_ENT.CD_EMP AND
	EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST = EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT=EST_NF_ENT.CD_NF

